function hideAndSubmitTimed(formid)
{
var timer=setTimeout("hideAndSubmit('"+formid+"');",5);
}

function hideAndSubmit(formid)
{
var formx=document.getElementById(formid);
		if (formx!=null)
		{	formx.style.visibility="hidden";
			formx.submit();
		}

}

function setItems(varNo)
{
	let qty=(varNo+1);
	let varEl=varNo!=null && varNo>0 ? document.getElementById("var"+varNo) : document.getElementById("orderDesc");
	let highValueBox=document.getElementById("highValue");
	let highValue=highValueBox!=null && highValueBox.checked;
	let discountBox=document.getElementById("discount");
	let discount=discountBox!=null && discountBox.checked;
	
	let cur=getInputValue("currency")
	if (varEl!=null)
	{
		let price=highValue? 3130 : 120;
		if ("SEK"==cur || "NOK"==cur || "CZK"==cur || "DKK"==cur)
		{
			price=highValue? 32000 : 1100;	
		}
		else if ("PLN"==cur)
		{
			price=420;
		}	
	
		let item={
			"t" : "p", "n" : "Item "+varNo, "c" : "80000"+varNo, "q" : qty,
			"qu" : "pc", "up" : (qty*price), "tt" : (qty*price*0.2), "tr" : 2000,
			"tp" : (qty*price)
		};
		

		let discountItem=null;
		let discountvalue=0;
		if (discount)
		{
			discountvalue=Math.round(item.tp*0.05);
			discountItem={
				"t" : "ds", "n" : "Discount 5%", "c" : "D5", "q" : 1,
				"qu" : "%", "up" : discountvalue, "tt" : 0, "tr" : 500,
				"tp" : discountvalue
			};
		}	
		let itemString=JSON.stringify(item);
		let discountString=discountItem!=null ? ","+JSON.stringify(discountItem) : "";
		varEl.value="items:["+itemString+discountString+"]";
		setTotal((item.tp-discountvalue)/100);
	}
}


function setTotal(val)
{
	let oaEl=document.getElementById("orderAmount");
	if (oaEl!=null)
	{
		oaEl.value=val;
	}
}

function toggleMode(select) 
{
	
	if ("minibrowser"==getInputValue(select.id))
	{	
		setInputValue("var9", "minibrowser");
	}
	else if ("iframe"==getInputValue(select.id))
	{	
		setInputValue("var9", "iframe");
	}
	else
	{
		setInputValue("var9", "");
	}
	
	let inFrame="iframe"==getInputValue(select.id);
	let form=document.getElementById("demoForm");
	let iFrame=document.getElementById("paymentFrame");
	if (form!=null && iFrame!=null)
	{
		if (inFrame)
		{	
			form.target="paymentFrame";
			iFrame.style.width="500px";
			iFrame.style.height="800px";
		}
		else
		{
			form.target="_self";
			iFrame.style.width="1px";
			iFrame.style.height="1px";
		}
	}
}	

function toggleExtraFields() 
{
		var extras = document.getElementsByClassName("hidden");
		if (extras.length == 0) {
			extras = document.getElementsByClassName("showing");
			for (var i = 0; i < extras.length; i++)
				extras[i].className = "hidden";
			document.getElementById("toggleBtn").value = "Show extra fields";
			document.getElementById("showExtras").value = "false";
		}
		else {
			for (i = 0; i < extras.length; i++) {
				extras[i].className = "showing";
			}
			document.getElementById("toggleBtn").value = "Hide extra fields"
			document.getElementById("showExtras").value = "true";

		}
}

function resetChildren(parent)
{
		var element=document.getElementById(parent);
		if (element!=null)
		{
			var children=element.children;
			for(i=0; i<children.length; i++)
			{
				if (children[i].type=="select" || children[i].type=="select-one" || children[i].type=="select-multiple")
				{
					try	  {	children[i].selectedIndex=0;} catch(err) { }
				}
				else if (children[i].type=="text" || children[i].type=="textarea" )
				{
					try	  {	children[i].value="";} catch(err) { }
				}
				else if (children[i].type=="checkbox")
				{
					try	  {	children[i].checked=false;} catch(err) { }
				}

			}
		}
}

const klarnaData=new Array();
	klarnaData["DE"]={"phone" : "+49-17614284340", "mail" : "payments@maksupay.com",
		"name" : "Mock Mock", "zip" :"10178", "city" : "Berlin", "street" : "Neue Schönhauser Str. 2" };
	
	klarnaData["AT"]={"phone" : "+43-06762600456", "mail" : "customer@email.at", 
		"name" : "Test Person-at", "zip" :"1060", "city" : "Wien", "street" : "Mariahilfer Straße 47", "state" : "9"};
	
	klarnaData["SE"]={"phone" : "+46-701740615", "mail" : "customer@email.se", 
		"name" : "Test Person-se", "zip" :"11 148", "city" : "Stockholm", "street" : "Södra Blasieholmshamnen 2" };
	
	klarnaData["PL"]={"phone" : "+48-128899000", "mail" : "customer@email.pl", 
			"name" : "Test Person-Pl", "zip" :"31-036", "city" : "Krakow", "street" : "Halicka 14a, Old Town" };

			
	klarnaData["ES"]={"phone" : "+34-672563009", "mail" : "customer@email.es", 
		"name" : "Test Person-es", "zip" :"28012", "city" : "Madrid", "street" : "C. de Atocha, 27" };

	klarnaData["GB"]={"phone" : "+447755564318", "mail" : "customer@email.uk", 
			"name" : "Test Person-uk", "zip" :"W1S 3BE", "city" : "London", "street" : "10 New Burlington Street Apt. 214", "state" :"ENG" };

	klarnaData["US"]={"phone" : "+1-672563009", "mail" : "customer@email.com", 
				"name" : "Test Person-us", "zip" :"94043", "city" : "Mountain View", "street" : "1600 Amphitheatre Parkway", "state" :"CA" };
		
function setItemData(country)
{
	let klarnaDataX=klarnaData[country];
	if (klarnaDataX!=null)
	{
		let ctrlEl=document.getElementById("billCountry");
		if (ctrlEl!=null)
		{
			ctrlEl.value=country;
		}

		let mailEl=document.getElementById("payerEmail");
		if (mailEl!=null)
		{
			mailEl.value=klarnaDataX.mail;
		}
		let phoneEl=document.getElementById("payerPhone");
		if (phoneEl!=null)
		{
			phoneEl.value=klarnaDataX.phone;
		}
		let nameEl=document.getElementById("payerName");
		if (nameEl!=null)
		{
			nameEl.value=klarnaDataX.name;
		}
		let cEl=document.getElementById("billCity");
		if (cEl!=null)
		{
			cEl.value=klarnaDataX.city;
		}
		let zEl=document.getElementById("billZip");
		if (zEl!=null)
		{
			zEl.value=klarnaDataX.zip;
		}
		let sEl=document.getElementById("billAddress");
		if (sEl!=null)
		{
			sEl.value=klarnaDataX.street;
		}
		let stEl=document.getElementById("billState");
		if (stEl!=null)
		{
			stEl.value=klarnaDataX.state!=null ? klarnaDataX.state : "";
		}


	}
	if ("SE"==country)
	{
		setInputValue("currency", "SEK");
	}
	else if ("NO"==country)
	{
		setInputValue("currency", "NOK");
	}	
	else if ("US"==country)
	{
		setInputValue("currency", "USD");
	}
	else if ("PL"==country)
	{
		setInputValue("currency", "PLN");
	}	
	else if ("DK"==country)
	{
		setInputValue("currency", "DKK");
	}	
	else if ("DE"==country || "AT"==country)
	{
		setInputValue("currency", "EUR");
	}	
	else if ("GB"==country)
	{
		setInputValue("currency", "GBP");
	}	
	
	setItems(0);	
}

function setSelectValue(selectId, value)
{
 let targetSelect=document.getElementById(selectId);
 if (targetSelect!=null && targetSelect.options!=null && targetSelect.options.length>0)
 {
 	for (let i=0; i<targetSelect.options.length; i++)
	{
		if (targetSelect.options[i].value==value)
		{
			targetSelect.selectedIndex=i;
			break;
		}
	}
 }
}

function getInputValue(inpputId)
{
	let pf=document.getElementById(inpputId);
	if (pf!=null)
	{
		if (pf.options)
		{	
			return pf.options[pf.selectedIndex].value;
		}	
		
		return pf.value;
	}
return null;
}	

function setInputValue(inpputId, value)
{
	let pf=document.getElementById(inpputId);
	if (pf!=null)
	{
		pf.value=value;
	}
}	


function finishMiniBrowser(popup, status, message) {
	const bc = new BroadcastChannel('payment');
	bc.postMessage({ status: status, message : message });
	// Close the popup
	popup.close();
}


function initMiniMessages() 
{
	const bc = new BroadcastChannel('payment');
	bc.onmessage = (e) => {
	  if (e.data) 
	{
	    setMiniStatus(e.data.status, e.data.message);
	  }
	};
}	

function setMiniStatus(status, message)
{
	document.getElementById("miniResult").innerHTML=""+status+", "+message;
}



function startPayment()
{
	let demoForm=document.getElementById("demoForm"); 
	let mode=getInputValue("mode");
	
	if ("minibrowser"==mode)
	{	
	
		demoForm.target="payment-popup";
		const popupWidth = 500;
	    const popupHeight = 650;

	    // Get current window position and size
	    const screenLeft = window.screenLeft !== undefined ? window.screenLeft : window.screenX;
	    const screenTop  = window.screenTop !== undefined ? window.screenTop : window.screenY;
	    const width     = window.innerWidth  || document.documentElement.clientWidth  || screen.width;
	    const height    = window.innerHeight || document.documentElement.clientHeight || screen.height;

	    // Calculate centered position
	    const left = screenLeft + (width  - popupWidth)  / 2;
	    const top  = screenTop  + (height - popupHeight) / 2;

		const popup = window.open(
					"",
			        "payment-popup",
			        "width="+popupWidth+",height="+popupHeight+",top="+top+",left="+left+"resizable=yes,scrollbars=yes,status=yes"
			    );
				
		initMiniMessages();
	}
	else if ("iframe"==mode)
	{
	
		initMiniMessages();	
		demoForm.target="paymentFrame";
	}	
	
	
	demoForm.submit();
	
 }