/**
 * MIT License
 * Copyright (c) 2025 Andri Kruus for Maksu GMBH
 * This file is released under the MIT License.
 */
using Microsoft.AspNetCore.Mvc;
using System.Net;
using Microsoft.AspNetCore.Mvc.ViewEngines;
using Microsoft.AspNetCore.Mvc.Rendering;
using Microsoft.AspNetCore.Mvc.ViewFeatures;

namespace Com.Maksupay.Sdk
{
	public class MaksuHandler : Controller
	{
		private readonly IConfiguration config;
	
	    public MaksuHandler(IConfiguration config)
	    {
	        this.config = config;
	    }

		 MaksuSDK maksuSDK=new MaksuSDK();

        // Renders Views/MaksuHandler/Index.cshtml
         [HttpGet]
        public IActionResult Index()
        {
			try
            {
				ViewBag.merchantKey = System.IO.File.ReadAllText("merchantKey.pem");
				ViewBag.merchantCert = System.IO.File.ReadAllText("merchantCert.pem");
				ViewBag.maksuCert = System.IO.File.ReadAllText("maksuCert.pem");
				ViewBag.config= config;
				ViewBag.maksuSDK = maksuSDK;
				ViewBag.httpContext = HttpContext; 
                return View();
            }
            catch (Exception ex)
			{
				string html =
	        "<h3 style='color:red'>MaksuSDK Error</h3>" +
    	    "<pre> " + WebUtility.HtmlEncode(ex.ToString()) + "</pre>";
		    return Content(html, "text/html");
			}	
        }

        [HttpPost]
        public IActionResult Index(IFormCollection form)
        {
         try 
         {
				ViewBag.config= config;
				ViewBag.maksuSDK = maksuSDK;
				ViewBag.httpContext = HttpContext; 
				
				Dictionary<string, string> requestParams=new Dictionary<string, string>();
				foreach (var item in form)
				{
					// normally you get those walues from your system this is just taking from form	
				 	requestParams[item.Key] = item.Value.ToString();
				}
				string postURL=MaksuSDK.GetParam(HttpContext, "maksuURL");
				string merchantKey=MaksuSDK.GetParam(HttpContext, "merchantKey");
				string merchantCert=MaksuSDK.GetParam(HttpContext, "merchantCert");
				ViewBag.payForm = maksuSDK.CreateMaksuRequestAsForm(merchantKey, merchantCert, postURL, requestParams); 
				string dv;
				if (requestParams.TryGetValue("signaturebase", out dv))
				{
				    // key exists → use value
				}
				else
				{
				    // key missing → avoid crash
				    dv = "";
				}
				ViewBag.debug=dv;
				ViewBag.postURL=postURL;
                return View("Index");
            }
            catch (Exception ex)
            {
                string html =
                    "<h3 style='color:red'>MaksuSDK Error (POST)</h3>" +
                    "<pre>" + WebUtility.HtmlEncode(ex.ToString()) + "</pre>";

                return Content(html, "text/html");
            }
        }
        
        
        [HttpPost("Return")]
        public IActionResult Return(IFormCollection form)
        {
         try 
            {
				ViewBag.config= config;
				ViewBag.maksuSDK = maksuSDK;
				ViewBag.httpContext = HttpContext; 
				
				Dictionary<string, string> requestParams=new Dictionary<string, string>();
				foreach (var item in form)
				{
				 	requestParams[item.Key] = item.Value.ToString();
				}
				string maksuCert = System.IO.File.ReadAllText("maksuCert.pem");
				ViewBag.resultValid="";
				string status=form["status"];
				try 
				{
					bool sigValid= maksuSDK.ValidateResponse(maksuCert, requestParams); 
					Console.WriteLine("Signature valid:"+sigValid);
					if (sigValid)
					{
						if (status=="AUTORIZED" || status=="CAPTURED")
						{
							ViewBag.resultValid="<span style='color: green;'>Signature valid, payment success, ship the order</span> ";
							// find order by your order id, update payment status
							//string orderId=requestParams["orderId"];
						}
						else if (status=="PENDING")
						{
							ViewBag.resultValid="<span style='color: blue;'>Signature valid, payment pending, dont ship the order yet, check status later</span> ";
						}
						else
						{
							ViewBag.resultValid="<span style='color: red;'>Signature valid, payment failed, retry payment</span>";
						}
					}	
					else
					{
						ViewBag.resultValid="<span style='color: red;'><b>Signature not valid</b>, ignore request like nothing happened</span>";
					}
				}
				catch(Exception e)
				{
					ViewBag.resultValid="Signature vlidation error, ignore request (but fix issue)";
					Console.WriteLine("Signature validation error");
					Console.WriteLine(e.ToString());
				}
				string dv;
				if (requestParams.TryGetValue("signaturebase", out dv))
				{
				    // key exists → use value
				}
				else
				{
				    // key missing → avoid crash
				    dv = "";
				}
				ViewBag.debug=dv;
                return View("Return");
            }
            catch (Exception ex)
            {
                string html =
                    "<h3 style='color:red'>MaksuSDK Error Return(POST)</h3>" +
                    "<pre>" + WebUtility.HtmlEncode(ex.ToString()) + "</pre>";

                return Content(html, "text/html");
            }
        }
        
        
          [HttpGet("api")]
        public IActionResult Api()
        {
			Console.WriteLine("Api get..");
			try
            {
				ViewBag.merchantKey = System.IO.File.ReadAllText("merchantKey.pem");
				ViewBag.merchantCert = System.IO.File.ReadAllText("merchantCert.pem");
				ViewBag.maksuCert = System.IO.File.ReadAllText("maksuCert.pem");
				ViewBag.config= config;
				ViewBag.maksuSDK = maksuSDK;
				ViewBag.httpContext = HttpContext; 
                return View();
            }
            catch (Exception ex)
			{
				string html =
	        "<h3 style='color:red'>MaksuSDK Error</h3>" +
    	    "<pre> " + WebUtility.HtmlEncode(ex.ToString()) + "</pre>";
		    return Content(html, "text/html");
			}	
        }


         [HttpPost("api")]
        public IActionResult ApiPost()
        {
			Console.WriteLine("Api post..");
			try
			{
				ViewBag.merchantKey = System.IO.File.ReadAllText("merchantKey.pem");
				ViewBag.merchantCert = System.IO.File.ReadAllText("merchantCert.pem");
				ViewBag.maksuCert = System.IO.File.ReadAllText("maksuCert.pem");
				ViewBag.config= config;
				ViewBag.maksuSDK = maksuSDK;
				ViewBag.httpContext = HttpContext; 
                return View("api");
            }
            catch (Exception ex)
			{
				string html =
	        "<h3 style='color:red'>MaksuSDK Error</h3>" +
    	    "<pre> " + WebUtility.HtmlEncode(ex.ToString()) + "</pre>";
		    return Content(html, "text/html");
			}	
        }
    }
}