/**
 * MIT License
 * Copyright (c) 2025 Andri Kruus for Maksu GMBH
 * This file is released under the MIT License.
 */
var builder = WebApplication.CreateBuilder(args);

builder.Services.AddControllersWithViews();
builder.Services.AddHttpContextAccessor();
builder.WebHost.UseWebRoot("/app/wwwroot");

string certPem = "fullchain.pem";
string keyPem  = "privkey.pem";

builder.WebHost.ConfigureKestrel(options =>
{
    // HTTP endpoint (always enabled)
    options.ListenAnyIP(8080);

/* if (File.Exists(certPem) && File.Exists(keyPem))
    {
        Console.WriteLine($"[TLS] Certificate found, enabling HTTPS on 8443");
        options.ListenAnyIP(8443, listenOptions =>
        {
           listenOptions.UseHttps(certPem, keyPem);
        });
    }
    else
    {
        Console.WriteLine("[TLS] Certificate not found, HTTPS disabled");
    }
*/
    
});


var app = builder.Build();

// Your app lives under /maksusdk
app.UsePathBase("/maksusdk");

// Serve static files from wwwroot normally
app.UseDefaultFiles();
app.UseStaticFiles();
app.UseRouting();

app.MapControllerRoute(
    name: "default",
    pattern: "{controller=MaksuHandler}/{action=Index}/{id?}"
);
app.UseForwardedHeaders();
app.Run();